<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Document;

class GoogleCloudDocumentaiUiv1beta3RevisionRef extends \Google\Model
{
  /**
   * Unspecified case, fall back to read the `LATEST_HUMAN_REVIEW`.
   */
  public const REVISION_CASE_REVISION_CASE_UNSPECIFIED = 'REVISION_CASE_UNSPECIFIED';
  /**
   * The latest revision made by a human.
   */
  public const REVISION_CASE_LATEST_HUMAN_REVIEW = 'LATEST_HUMAN_REVIEW';
  /**
   * The latest revision based on timestamp.
   */
  public const REVISION_CASE_LATEST_TIMESTAMP = 'LATEST_TIMESTAMP';
  /**
   * The first (OCR) revision.
   */
  public const REVISION_CASE_BASE_OCR_REVISION = 'BASE_OCR_REVISION';
  /**
   * Reads the revision generated by the processor version. The format takes the
   * full resource name of processor version. `projects/{project}/locations/{loc
   * ation}/processors/{processor}/processorVersions/{processorVersion}`
   *
   * @var string
   */
  public $latestProcessorVersion;
  /**
   * Reads the revision by the predefined case.
   *
   * @var string
   */
  public $revisionCase;
  /**
   * Reads the revision given by the id.
   *
   * @var string
   */
  public $revisionId;

  /**
   * Reads the revision generated by the processor version. The format takes the
   * full resource name of processor version. `projects/{project}/locations/{loc
   * ation}/processors/{processor}/processorVersions/{processorVersion}`
   *
   * @param string $latestProcessorVersion
   */
  public function setLatestProcessorVersion($latestProcessorVersion)
  {
    $this->latestProcessorVersion = $latestProcessorVersion;
  }
  /**
   * @return string
   */
  public function getLatestProcessorVersion()
  {
    return $this->latestProcessorVersion;
  }
  /**
   * Reads the revision by the predefined case.
   *
   * Accepted values: REVISION_CASE_UNSPECIFIED, LATEST_HUMAN_REVIEW,
   * LATEST_TIMESTAMP, BASE_OCR_REVISION
   *
   * @param self::REVISION_CASE_* $revisionCase
   */
  public function setRevisionCase($revisionCase)
  {
    $this->revisionCase = $revisionCase;
  }
  /**
   * @return self::REVISION_CASE_*
   */
  public function getRevisionCase()
  {
    return $this->revisionCase;
  }
  /**
   * Reads the revision given by the id.
   *
   * @param string $revisionId
   */
  public function setRevisionId($revisionId)
  {
    $this->revisionId = $revisionId;
  }
  /**
   * @return string
   */
  public function getRevisionId()
  {
    return $this->revisionId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDocumentaiUiv1beta3RevisionRef::class, 'Google_Service_Document_GoogleCloudDocumentaiUiv1beta3RevisionRef');
