<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DriveActivity;

class DataLeakPreventionChange extends \Google\Model
{
  /**
   * An update to the DLP state that is neither FLAGGED or CLEARED.
   */
  public const TYPE_TYPE_UNSPECIFIED = 'TYPE_UNSPECIFIED';
  /**
   * Document has been flagged as containing sensitive content.
   */
  public const TYPE_FLAGGED = 'FLAGGED';
  /**
   * Document is no longer flagged as containing sensitive content.
   */
  public const TYPE_CLEARED = 'CLEARED';
  /**
   * The type of Data Leak Prevention (DLP) change.
   *
   * @var string
   */
  public $type;

  /**
   * The type of Data Leak Prevention (DLP) change.
   *
   * Accepted values: TYPE_UNSPECIFIED, FLAGGED, CLEARED
   *
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DataLeakPreventionChange::class, 'Google_Service_DriveActivity_DataLeakPreventionChange');
